#include <GUIConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

Opt("GUIOnEventMode", 1) ; 1 = enable
Opt("GUIEventOptions", 0) ; 0 = (default) Windows behavior on click on Minimize,Restore, Maximize, Resize.

$hGui = GUICreate("Test double event")
GUISetBkColor(0xABCDEF, $hGui)

; --------------------------------------------------
; Calling any of these will create the issue
; --------------------------------------------------
GUICtrlSetDefColor(0x222222)
GUICtrlSetDefbKColor(0x9ABCDE)

GUISetOnEvent($GUI_EVENT_CLOSE, "guiEventsHandler", $hGui)
GUISetOnEvent($GUI_EVENT_RESTORE, "guiEventsHandler", $hGui)
GUISetOnEvent($GUI_EVENT_MINIMIZE, "guiEventsHandler", $hGui)

$testButton = GuiCtrlCreateButton("Test input", 8, 8, 100)
GUICtrlSetOnEvent($testButton, buttonHandler)

$testInput = GuiCtrlCreateInput("asdasd", 8, 48, 100)
GUICtrlSetOnEvent($testInput, inputHandler)

GUISetState()

While 1
	Sleep(10)
WEnd

Func guiEventsHandler()
	If @GUI_CtrlId == $GUI_EVENT_CLOSE Then Exit
	If @GUI_CtrlId == $GUI_EVENT_RESTORE Then GUISetState(@SW_RESTORE, @GUI_WinHandle)
	If @GUI_CtrlId == $GUI_EVENT_MAXIMIZE Then GUISetState(@SW_MAXIMIZE, @GUI_WinHandle)
	If @GUI_CtrlId == $GUI_EVENT_MINIMIZE Then GUISetState(@SW_MINIMIZE, @GUI_WinHandle)
EndFunc

Func buttonHandler()
	MsgBox(0, "Button handler", "Got an event from the button")
EndFunc

Func inputHandler()
	MsgBox(0, "Input handler", "Got an event from the input")
EndFunc